
// This scilab code is to perform basic morphological operation on image
//such as erosion and dilation, opening and closing an image

//The scilab environment for this is : Scilab 5.5.2

//Toolbox used: Image Processing Desing (IPD) Toolbox ver. 8.3.3
//                SIVP 0.5.3.2

//OS used : Windows 10 64 bit
// 
//Reference book name : Digital Image Processing
//book author: Rafael C. Gonzalez and Richard E. Woods

clc //to clear command window.
clear all //to kill previously defined variables.
xdel(winsid())//to close all currently open figure(s).

//This code uses camaraman.tif file for processing
//SCI + '/contrib/SIVP_0.5.3.2/images/lena.png'
img = imread('Fig0419.png');  // Reads the text image (Image from References)
//title("Original Image");
imshow(img);                    // Show original image.
if(size(img,3)>1) then 
    Gray_img= rgb2gray(img);    //Converts color image to grayscale
else 
    Gray_img=img;               // if image is 2D image
end
SE=CreateStructureElement('square',3); // create structuring element 3x3 square matrix

Eimg=ErodeImage(Gray_img,SE); // erosion of the image
pause;                          // type 'resume' command on command prompt
imshow(Eimg);                   // show Resultant image
//se=[1 1 1;1 1 1;1 1 1];
Dimg=DilateImage(Gray_img,SE);  // dilation of the image
pause;                          // type 'resume' command on command prompt 
imshow(Dimg);                    // Show Resultant Image

Oimg=OpenImage(Gray_img,SE);  // opening operation on the image
pause;                          // type 'resume' command on command prompt 
imshow(Oimg);                    // Show Resultant Image


Cimg=CloseImage(Gray_img,SE);  // closing operation on the image
pause;                          // type 'resume' command on command prompt 
imshow(Cimg);                    // Show Resultant Image
